package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InfrastructureConfigurationArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteInfrastructureConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    infrastructureConfigurationArn: Option[InfrastructureConfigurationArn] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse = {
    import DeleteInfrastructureConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        infrastructureConfigurationArn.map(value =>
          InfrastructureConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.infrastructureConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse
      .wrap(buildAwsValue())
}
object DeleteInfrastructureConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse =
      zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse(
        requestId.map(value => value),
        infrastructureConfigurationArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def infrastructureConfigurationArn: Option[InfrastructureConfigurationArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getInfrastructureConfigurationArn
        : ZIO[Any, AwsError, InfrastructureConfigurationArn] =
      AwsError.unwrapOptionField(
        "infrastructureConfigurationArn",
        infrastructureConfigurationArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
  ) extends zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val infrastructureConfigurationArn
        : Option[InfrastructureConfigurationArn] = scala
      .Option(impl.infrastructureConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .InfrastructureConfigurationArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteInfrastructureConfigurationResponse
  ): zio.aws.imagebuilder.model.DeleteInfrastructureConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
