package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InstanceProfileNameType,
  TagValue,
  SnsTopicArn,
  InstanceType,
  ClientToken,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateInfrastructureConfigurationRequest(
    name: ResourceName,
    description: Option[NonEmptyString] = None,
    instanceTypes: Option[Iterable[InstanceType]] = None,
    instanceProfileName: InstanceProfileNameType,
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetId: Option[NonEmptyString] = None,
    logging: Option[zio.aws.imagebuilder.model.Logging] = None,
    keyPair: Option[NonEmptyString] = None,
    terminateInstanceOnFailure: Option[NullableBoolean] = None,
    snsTopicArn: Option[SnsTopicArn] = None,
    resourceTags: Option[Map[TagKey, TagValue]] = None,
    instanceMetadataOptions: Option[
      zio.aws.imagebuilder.model.InstanceMetadataOptions
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest = {
    import CreateInfrastructureConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .instanceProfileName(
        InstanceProfileNameType.unwrap(instanceProfileName): java.lang.String
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(
        keyPair.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        terminateInstanceOnFailure.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.terminateInstanceOnFailure)
      .optionallyWith(
        snsTopicArn.map(value => SnsTopicArn.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        resourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.resourceTags)
      .optionallyWith(
        instanceMetadataOptions.map(value => value.buildAwsValue())
      )(_.instanceMetadataOptions)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateInfrastructureConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest =
      zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest(
        name,
        description.map(value => value),
        instanceTypes.map(value => value),
        instanceProfileName,
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        logging.map(value => value.asEditable),
        keyPair.map(value => value),
        terminateInstanceOnFailure.map(value => value),
        snsTopicArn.map(value => value),
        resourceTags.map(value => value),
        instanceMetadataOptions.map(value => value.asEditable),
        tags.map(value => value),
        clientToken
      )
    def name: ResourceName
    def description: Option[NonEmptyString]
    def instanceTypes: Option[List[InstanceType]]
    def instanceProfileName: InstanceProfileNameType
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetId: Option[NonEmptyString]
    def logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly]
    def keyPair: Option[NonEmptyString]
    def terminateInstanceOnFailure: Option[NullableBoolean]
    def snsTopicArn: Option[SnsTopicArn]
    def resourceTags: Option[Map[TagKey, TagValue]]
    def instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getInstanceProfileName: ZIO[Any, Nothing, InstanceProfileNameType] =
      ZIO.succeed(instanceProfileName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getKeyPair: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getTerminateInstanceOnFailure: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "terminateInstanceOnFailure",
        terminateInstanceOnFailure
      )
    def getSnsTopicArn: ZIO[Any, AwsError, SnsTopicArn] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getResourceTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getInstanceMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataOptions",
      instanceMetadataOptions
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
  ) extends zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val instanceTypes: Option[List[InstanceType]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.InstanceType(item)
        }.toList
      )
    override val instanceProfileName: InstanceProfileNameType =
      zio.aws.imagebuilder.model.primitives
        .InstanceProfileNameType(impl.instanceProfileName())
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetId: Option[NonEmptyString] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly] =
      scala
        .Option(impl.logging())
        .map(value => zio.aws.imagebuilder.model.Logging.wrap(value))
    override val keyPair: Option[NonEmptyString] = scala
      .Option(impl.keyPair())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val terminateInstanceOnFailure: Option[NullableBoolean] = scala
      .Option(impl.terminateInstanceOnFailure())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NullableBoolean(value)
      )
    override val snsTopicArn: Option[SnsTopicArn] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.imagebuilder.model.primitives.SnsTopicArn(value))
    override val resourceTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly] =
      scala
        .Option(impl.instanceMetadataOptions())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceMetadataOptions.wrap(value)
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateInfrastructureConfigurationRequest
  ): zio.aws.imagebuilder.model.CreateInfrastructureConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
