package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContainerDistributionConfiguration(
    description: Option[NonEmptyString] = None,
    containerTags: Option[Iterable[NonEmptyString]] = None,
    targetRepository: zio.aws.imagebuilder.model.TargetContainerRepository
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration = {
    import ContainerDistributionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration
      .builder()
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        containerTags.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.containerTags)
      .targetRepository(targetRepository.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.ContainerDistributionConfiguration
      .wrap(buildAwsValue())
}
object ContainerDistributionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ContainerDistributionConfiguration =
      zio.aws.imagebuilder.model.ContainerDistributionConfiguration(
        description.map(value => value),
        containerTags.map(value => value),
        targetRepository.asEditable
      )
    def description: Option[NonEmptyString]
    def containerTags: Option[List[NonEmptyString]]
    def targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getContainerTags: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("containerTags", containerTags)
    def getTargetRepository: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly
    ] = ZIO.succeed(targetRepository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration
  ) extends zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly {
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerTags: Option[List[NonEmptyString]] = scala
      .Option(impl.containerTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val targetRepository
        : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly =
      zio.aws.imagebuilder.model.TargetContainerRepository
        .wrap(impl.targetRepository())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ContainerDistributionConfiguration
  ): zio.aws.imagebuilder.model.ContainerDistributionConfiguration.ReadOnly =
    new Wrapper(impl)
}
