package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuildVersionArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelImageCreationResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    imageBuildVersionArn: Option[ImageBuildVersionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse = {
    import CancelImageCreationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly =
    zio.aws.imagebuilder.model.CancelImageCreationResponse.wrap(buildAwsValue())
}
object CancelImageCreationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CancelImageCreationResponse =
      zio.aws.imagebuilder.model.CancelImageCreationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        imageBuildVersionArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def imageBuildVersionArn: Option[ImageBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ) extends zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imageBuildVersionArn: Option[ImageBuildVersionArn] = scala
      .Option(impl.imageBuildVersionArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ): zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly =
    new Wrapper(impl)
}
