package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.UserDataOverride
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AdditionalInstanceConfiguration(
    systemsManagerAgent: Option[
      zio.aws.imagebuilder.model.SystemsManagerAgent
    ] = None,
    userDataOverride: Option[UserDataOverride] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration = {
    import AdditionalInstanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
      .builder()
      .optionallyWith(systemsManagerAgent.map(value => value.buildAwsValue()))(
        _.systemsManagerAgent
      )
      .optionallyWith(
        userDataOverride.map(value =>
          UserDataOverride.unwrap(value): java.lang.String
        )
      )(_.userDataOverride)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.AdditionalInstanceConfiguration
      .wrap(buildAwsValue())
}
object AdditionalInstanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.AdditionalInstanceConfiguration =
      zio.aws.imagebuilder.model.AdditionalInstanceConfiguration(
        systemsManagerAgent.map(value => value.asEditable),
        userDataOverride.map(value => value)
      )
    def systemsManagerAgent
        : Option[zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly]
    def userDataOverride: Option[UserDataOverride]
    def getSystemsManagerAgent: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly
    ] = AwsError.unwrapOptionField("systemsManagerAgent", systemsManagerAgent)
    def getUserDataOverride: ZIO[Any, AwsError, UserDataOverride] =
      AwsError.unwrapOptionField("userDataOverride", userDataOverride)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ) extends zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly {
    override val systemsManagerAgent
        : Option[zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly] =
      scala
        .Option(impl.systemsManagerAgent())
        .map(value =>
          zio.aws.imagebuilder.model.SystemsManagerAgent.wrap(value)
        )
    override val userDataOverride: Option[UserDataOverride] = scala
      .Option(impl.userDataOverride())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.UserDataOverride(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.AdditionalInstanceConfiguration
  ): zio.aws.imagebuilder.model.AdditionalInstanceConfiguration.ReadOnly =
    new Wrapper(impl)
}
