package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImagePipelineArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateImagePipelineResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    imagePipelineArn: Option[ImagePipelineArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse = {
    import UpdateImagePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly =
    zio.aws.imagebuilder.model.UpdateImagePipelineResponse.wrap(buildAwsValue())
}
object UpdateImagePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.UpdateImagePipelineResponse =
      zio.aws.imagebuilder.model.UpdateImagePipelineResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        imagePipelineArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def imagePipelineArn: Option[ImagePipelineArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse
  ) extends zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imagePipelineArn: Option[ImagePipelineArn] = scala
      .Option(impl.imagePipelineArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateImagePipelineResponse
  ): zio.aws.imagebuilder.model.UpdateImagePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
