package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  InstanceProfileNameType,
  ImageBuilderArn,
  TagValue,
  InstanceType,
  DateTime,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InfrastructureConfiguration(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    description: Option[NonEmptyString] = None,
    instanceTypes: Option[Iterable[InstanceType]] = None,
    instanceProfileName: Option[InstanceProfileNameType] = None,
    securityGroupIds: Option[Iterable[NonEmptyString]] = None,
    subnetId: Option[NonEmptyString] = None,
    logging: Option[zio.aws.imagebuilder.model.Logging] = None,
    keyPair: Option[NonEmptyString] = None,
    terminateInstanceOnFailure: Option[NullableBoolean] = None,
    snsTopicArn: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None,
    dateUpdated: Option[DateTime] = None,
    resourceTags: Option[Map[TagKey, TagValue]] = None,
    instanceMetadataOptions: Option[
      zio.aws.imagebuilder.model.InstanceMetadataOptions
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration = {
    import InfrastructureConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        instanceTypes.map(value =>
          value.map { item =>
            InstanceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceTypes)
      .optionallyWith(
        instanceProfileName.map(value =>
          InstanceProfileNameType.unwrap(value): java.lang.String
        )
      )(_.instanceProfileName)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(
        keyPair.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyPair)
      .optionallyWith(
        terminateInstanceOnFailure.map(value =>
          NullableBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.terminateInstanceOnFailure)
      .optionallyWith(
        snsTopicArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snsTopicArn)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(
        dateUpdated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateUpdated)
      .optionallyWith(
        resourceTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.resourceTags)
      .optionallyWith(
        instanceMetadataOptions.map(value => value.buildAwsValue())
      )(_.instanceMetadataOptions)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.InfrastructureConfiguration.wrap(buildAwsValue())
}
object InfrastructureConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InfrastructureConfiguration =
      zio.aws.imagebuilder.model.InfrastructureConfiguration(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        instanceTypes.map(value => value),
        instanceProfileName.map(value => value),
        securityGroupIds.map(value => value),
        subnetId.map(value => value),
        logging.map(value => value.asEditable),
        keyPair.map(value => value),
        terminateInstanceOnFailure.map(value => value),
        snsTopicArn.map(value => value),
        dateCreated.map(value => value),
        dateUpdated.map(value => value),
        resourceTags.map(value => value),
        instanceMetadataOptions.map(value => value.asEditable),
        tags.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def description: Option[NonEmptyString]
    def instanceTypes: Option[List[InstanceType]]
    def instanceProfileName: Option[InstanceProfileNameType]
    def securityGroupIds: Option[List[NonEmptyString]]
    def subnetId: Option[NonEmptyString]
    def logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly]
    def keyPair: Option[NonEmptyString]
    def terminateInstanceOnFailure: Option[NullableBoolean]
    def snsTopicArn: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def dateUpdated: Option[DateTime]
    def resourceTags: Option[Map[TagKey, TagValue]]
    def instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceTypes: ZIO[Any, AwsError, List[InstanceType]] =
      AwsError.unwrapOptionField("instanceTypes", instanceTypes)
    def getInstanceProfileName: ZIO[Any, AwsError, InstanceProfileNameType] =
      AwsError.unwrapOptionField("instanceProfileName", instanceProfileName)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getKeyPair: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPair", keyPair)
    def getTerminateInstanceOnFailure: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "terminateInstanceOnFailure",
        terminateInstanceOnFailure
      )
    def getSnsTopicArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snsTopicArn", snsTopicArn)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateUpdated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateUpdated", dateUpdated)
    def getResourceTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getInstanceMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceMetadataOptions",
      instanceMetadataOptions
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ) extends zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val instanceTypes: Option[List[InstanceType]] = scala
      .Option(impl.instanceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.InstanceType(item)
        }.toList
      )
    override val instanceProfileName: Option[InstanceProfileNameType] = scala
      .Option(impl.instanceProfileName())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.InstanceProfileNameType(value)
      )
    override val securityGroupIds: Option[List[NonEmptyString]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val subnetId: Option[NonEmptyString] = scala
      .Option(impl.subnetId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val logging: Option[zio.aws.imagebuilder.model.Logging.ReadOnly] =
      scala
        .Option(impl.logging())
        .map(value => zio.aws.imagebuilder.model.Logging.wrap(value))
    override val keyPair: Option[NonEmptyString] = scala
      .Option(impl.keyPair())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val terminateInstanceOnFailure: Option[NullableBoolean] = scala
      .Option(impl.terminateInstanceOnFailure())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NullableBoolean(value)
      )
    override val snsTopicArn: Option[NonEmptyString] = scala
      .Option(impl.snsTopicArn())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val dateUpdated: Option[DateTime] = scala
      .Option(impl.dateUpdated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val resourceTags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.resourceTags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val instanceMetadataOptions
        : Option[zio.aws.imagebuilder.model.InstanceMetadataOptions.ReadOnly] =
      scala
        .Option(impl.instanceMetadataOptions())
        .map(value =>
          zio.aws.imagebuilder.model.InstanceMetadataOptions.wrap(value)
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration
  ): zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly =
    new Wrapper(impl)
}
