package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait EbsVolumeType {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType
}
object EbsVolumeType {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType
  ): zio.aws.imagebuilder.model.EbsVolumeType = value match {
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.IO1 =>
      val r = io1
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.IO2 =>
      val r = io2
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.GP2 =>
      val r = gp2
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.GP3 =>
      val r = gp3
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.SC1 =>
      val r = sc1
      r
    case software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.ST1 =>
      val r = st1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.STANDARD
  }
  case object io1 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.IO1
  }
  case object io2 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.IO2
  }
  case object gp2 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.GP2
  }
  case object gp3 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.GP3
  }
  case object sc1 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.SC1
  }
  case object st1 extends zio.aws.imagebuilder.model.EbsVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType =
      software.amazon.awssdk.services.imagebuilder.model.EbsVolumeType.ST1
  }
}
