package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImageVersion(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    `type`: Option[zio.aws.imagebuilder.model.ImageType] = None,
    version: Option[VersionNumber] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    osVersion: Option[OsVersion] = None,
    owner: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None,
    buildType: Option[zio.aws.imagebuilder.model.BuildType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImageVersion = {
    import ImageVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImageVersion
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        osVersion.map(value => OsVersion.unwrap(value): java.lang.String)
      )(_.osVersion)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .optionallyWith(buildType.map(value => value.unwrap))(_.buildType)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImageVersion.ReadOnly =
    zio.aws.imagebuilder.model.ImageVersion.wrap(buildAwsValue())
}
object ImageVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImageVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImageVersion =
      zio.aws.imagebuilder.model.ImageVersion(
        arn.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        version.map(value => value),
        platform.map(value => value),
        osVersion.map(value => value),
        owner.map(value => value),
        dateCreated.map(value => value),
        buildType.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def `type`: Option[zio.aws.imagebuilder.model.ImageType]
    def version: Option[VersionNumber]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def osVersion: Option[OsVersion]
    def owner: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def buildType: Option[zio.aws.imagebuilder.model.BuildType]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageType] =
      AwsError.unwrapOptionField("type", `type`)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getOsVersion: ZIO[Any, AwsError, OsVersion] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getBuildType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.BuildType] =
      AwsError.unwrapOptionField("buildType", buildType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageVersion
  ) extends zio.aws.imagebuilder.model.ImageVersion.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val `type`: Option[zio.aws.imagebuilder.model.ImageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.imagebuilder.model.ImageType.wrap(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val osVersion: Option[OsVersion] = scala
      .Option(impl.osVersion())
      .map(value => zio.aws.imagebuilder.model.primitives.OsVersion(value))
    override val owner: Option[NonEmptyString] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val buildType: Option[zio.aws.imagebuilder.model.BuildType] = scala
      .Option(impl.buildType())
      .map(value => zio.aws.imagebuilder.model.BuildType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImageVersion
  ): zio.aws.imagebuilder.model.ImageVersion.ReadOnly = new Wrapper(impl)
}
