package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{TagValue, TagKey, ImageBuilderArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ImageBuilderArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest
      .builder()
      .resourceArn(ImageBuilderArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.TagResourceRequest.ReadOnly =
    zio.aws.imagebuilder.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.TagResourceRequest =
      zio.aws.imagebuilder.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ImageBuilderArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ImageBuilderArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest
  ) extends zio.aws.imagebuilder.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ImageBuilderArn =
      zio.aws.imagebuilder.model.primitives.ImageBuilderArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.imagebuilder.model.primitives
          .TagKey(key) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.TagResourceRequest
  ): zio.aws.imagebuilder.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
