package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListInfrastructureConfigurationsResponse(
    requestId: Option[NonEmptyString] = None,
    infrastructureConfigurationSummaryList: Option[
      Iterable[zio.aws.imagebuilder.model.InfrastructureConfigurationSummary]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse = {
    import ListInfrastructureConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        infrastructureConfigurationSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.infrastructureConfigurationSummaryList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListInfrastructureConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse =
      zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse(
        requestId.map(value => value),
        infrastructureConfigurationSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def infrastructureConfigurationSummaryList: Option[List[
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
    ]]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getInfrastructureConfigurationSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "infrastructureConfigurationSummaryList",
      infrastructureConfigurationSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
  ) extends zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val infrastructureConfigurationSummaryList: Option[List[
      zio.aws.imagebuilder.model.InfrastructureConfigurationSummary.ReadOnly
    ]] = scala
      .Option(impl.infrastructureConfigurationSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.InfrastructureConfigurationSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListInfrastructureConfigurationsResponse
  ): zio.aws.imagebuilder.model.ListInfrastructureConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
