package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetInfrastructureConfigurationResponse(
    requestId: Option[NonEmptyString] = None,
    infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse = {
    import GetInfrastructureConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        infrastructureConfiguration.map(value => value.buildAwsValue())
      )(_.infrastructureConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse
      .wrap(buildAwsValue())
}
object GetInfrastructureConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse =
      zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse(
        requestId.map(value => value),
        infrastructureConfiguration.map(value => value.asEditable)
      )
    def requestId: Option[NonEmptyString]
    def infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getInfrastructureConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "infrastructureConfiguration",
      infrastructureConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse
  ) extends zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val infrastructureConfiguration: Option[
      zio.aws.imagebuilder.model.InfrastructureConfiguration.ReadOnly
    ] = scala
      .Option(impl.infrastructureConfiguration())
      .map(value =>
        zio.aws.imagebuilder.model.InfrastructureConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetInfrastructureConfigurationResponse
  ): zio.aws.imagebuilder.model.GetInfrastructureConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
