package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImageRecipeArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutImageRecipePolicyResponse(
    requestId: Option[NonEmptyString] = None,
    imageRecipeArn: Option[ImageRecipeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse = {
    import PutImageRecipePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly =
    zio.aws.imagebuilder.model.PutImageRecipePolicyResponse
      .wrap(buildAwsValue())
}
object PutImageRecipePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.PutImageRecipePolicyResponse =
      zio.aws.imagebuilder.model.PutImageRecipePolicyResponse(
        requestId.map(value => value),
        imageRecipeArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imageRecipeArn: Option[ImageRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ) extends zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Option[ImageRecipeArn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.PutImageRecipePolicyResponse
  ): zio.aws.imagebuilder.model.PutImageRecipePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
