package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{PaginationToken, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListImagesResponse(
    requestId: Option[NonEmptyString] = None,
    imageVersionList: Option[
      Iterable[zio.aws.imagebuilder.model.ImageVersion]
    ] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse = {
    import ListImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageVersionList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imageVersionList)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListImagesResponse.wrap(buildAwsValue())
}
object ListImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListImagesResponse =
      zio.aws.imagebuilder.model.ListImagesResponse(
        requestId.map(value => value),
        imageVersionList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imageVersionList
        : Option[List[zio.aws.imagebuilder.model.ImageVersion.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageVersionList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ImageVersion.ReadOnly
    ]] = AwsError.unwrapOptionField("imageVersionList", imageVersionList)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse
  ) extends zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageVersionList
        : Option[List[zio.aws.imagebuilder.model.ImageVersion.ReadOnly]] = scala
      .Option(impl.imageVersionList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ImageVersion.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListImagesResponse
  ): zio.aws.imagebuilder.model.ListImagesResponse.ReadOnly = new Wrapper(impl)
}
