package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuilderArn,
  DateTime,
  VersionNumber,
  OsVersion,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ComponentVersion(
    arn: Option[ImageBuilderArn] = None,
    name: Option[ResourceName] = None,
    version: Option[VersionNumber] = None,
    description: Option[NonEmptyString] = None,
    platform: Option[zio.aws.imagebuilder.model.Platform] = None,
    supportedOsVersions: Option[Iterable[OsVersion]] = None,
    `type`: Option[zio.aws.imagebuilder.model.ComponentType] = None,
    owner: Option[NonEmptyString] = None,
    dateCreated: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ComponentVersion = {
    import ComponentVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
      .builder()
      .optionallyWith(
        arn.map(value => ImageBuilderArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => VersionNumber.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(platform.map(value => value.unwrap))(_.platform)
      .optionallyWith(
        supportedOsVersions.map(value =>
          value.map { item =>
            OsVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedOsVersions)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        dateCreated.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.dateCreated)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ComponentVersion.ReadOnly =
    zio.aws.imagebuilder.model.ComponentVersion.wrap(buildAwsValue())
}
object ComponentVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ComponentVersion =
      zio.aws.imagebuilder.model.ComponentVersion(
        arn.map(value => value),
        name.map(value => value),
        version.map(value => value),
        description.map(value => value),
        platform.map(value => value),
        supportedOsVersions.map(value => value),
        `type`.map(value => value),
        owner.map(value => value),
        dateCreated.map(value => value)
      )
    def arn: Option[ImageBuilderArn]
    def name: Option[ResourceName]
    def version: Option[VersionNumber]
    def description: Option[NonEmptyString]
    def platform: Option[zio.aws.imagebuilder.model.Platform]
    def supportedOsVersions: Option[List[OsVersion]]
    def `type`: Option[zio.aws.imagebuilder.model.ComponentType]
    def owner: Option[NonEmptyString]
    def dateCreated: Option[DateTime]
    def getArn: ZIO[Any, AwsError, ImageBuilderArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, VersionNumber] =
      AwsError.unwrapOptionField("version", version)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getPlatform: ZIO[Any, AwsError, zio.aws.imagebuilder.model.Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getSupportedOsVersions: ZIO[Any, AwsError, List[OsVersion]] =
      AwsError.unwrapOptionField("supportedOsVersions", supportedOsVersions)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.ComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getDateCreated: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ) extends zio.aws.imagebuilder.model.ComponentVersion.ReadOnly {
    override val arn: Option[ImageBuilderArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImageBuilderArn(value)
      )
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.ResourceName(value))
    override val version: Option[VersionNumber] = scala
      .Option(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.VersionNumber(value))
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val platform: Option[zio.aws.imagebuilder.model.Platform] = scala
      .Option(impl.platform())
      .map(value => zio.aws.imagebuilder.model.Platform.wrap(value))
    override val supportedOsVersions: Option[List[OsVersion]] = scala
      .Option(impl.supportedOsVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.primitives.OsVersion(item)
        }.toList
      )
    override val `type`: Option[zio.aws.imagebuilder.model.ComponentType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.ComponentType.wrap(value))
    override val owner: Option[NonEmptyString] = scala
      .Option(impl.owner())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val dateCreated: Option[DateTime] = scala
      .Option(impl.dateCreated())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ComponentVersion
  ): zio.aws.imagebuilder.model.ComponentVersion.ReadOnly = new Wrapper(impl)
}
