package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ComponentBuildVersionArn,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteComponentResponse(
    requestId: Option[NonEmptyString] = None,
    componentBuildVersionArn: Option[ComponentBuildVersionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse = {
    import DeleteComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        componentBuildVersionArn.map(value =>
          ComponentBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.componentBuildVersionArn)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteComponentResponse.wrap(buildAwsValue())
}
object DeleteComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteComponentResponse =
      zio.aws.imagebuilder.model.DeleteComponentResponse(
        requestId.map(value => value),
        componentBuildVersionArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def componentBuildVersionArn: Option[ComponentBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getComponentBuildVersionArn
        : ZIO[Any, AwsError, ComponentBuildVersionArn] = AwsError
      .unwrapOptionField("componentBuildVersionArn", componentBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ) extends zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val componentBuildVersionArn: Option[ComponentBuildVersionArn] =
      scala
        .Option(impl.componentBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ComponentBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteComponentResponse
  ): zio.aws.imagebuilder.model.DeleteComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
