package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageRecipeArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateImageRecipeResponse(
    requestId: Option[NonEmptyString] = None,
    clientToken: Option[ClientToken] = None,
    imageRecipeArn: Option[ImageRecipeArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse = {
    import CreateImageRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.CreateImageRecipeResponse.wrap(buildAwsValue())
}
object CreateImageRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImageRecipeResponse =
      zio.aws.imagebuilder.model.CreateImageRecipeResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        imageRecipeArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def clientToken: Option[ClientToken]
    def imageRecipeArn: Option[ImageRecipeArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse
  ) extends zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imageRecipeArn: Option[ImageRecipeArn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImageRecipeResponse
  ): zio.aws.imagebuilder.model.CreateImageRecipeResponse.ReadOnly =
    new Wrapper(impl)
}
