package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NullableBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SystemsManagerAgent(
    uninstallAfterBuild: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent = {
    import SystemsManagerAgent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
      .builder()
      .optionallyWith(
        uninstallAfterBuild.map(value => value: java.lang.Boolean)
      )(_.uninstallAfterBuild)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly =
    zio.aws.imagebuilder.model.SystemsManagerAgent.wrap(buildAwsValue())
}
object SystemsManagerAgent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.SystemsManagerAgent =
      zio.aws.imagebuilder.model
        .SystemsManagerAgent(uninstallAfterBuild.map(value => value))
    def uninstallAfterBuild: Optional[NullableBoolean]
    def getUninstallAfterBuild: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("uninstallAfterBuild", uninstallAfterBuild)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ) extends zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly {
    override val uninstallAfterBuild: Optional[NullableBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uninstallAfterBuild())
        .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.SystemsManagerAgent
  ): zio.aws.imagebuilder.model.SystemsManagerAgent.ReadOnly = new Wrapper(impl)
}
