package zio.aws.imagebuilder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Remediation(
    recommendation: Optional[
      zio.aws.imagebuilder.model.RemediationRecommendation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Remediation = {
    import Remediation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Remediation
      .builder()
      .optionallyWith(recommendation.map(value => value.buildAwsValue()))(
        _.recommendation
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Remediation.ReadOnly =
    zio.aws.imagebuilder.model.Remediation.wrap(buildAwsValue())
}
object Remediation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.Remediation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Remediation =
      zio.aws.imagebuilder.model
        .Remediation(recommendation.map(value => value.asEditable))
    def recommendation: Optional[
      zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly
    ]
    def getRecommendation: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly
    ] = AwsError.unwrapOptionField("recommendation", recommendation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Remediation
  ) extends zio.aws.imagebuilder.model.Remediation.ReadOnly {
    override val recommendation: Optional[
      zio.aws.imagebuilder.model.RemediationRecommendation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recommendation())
      .map(value =>
        zio.aws.imagebuilder.model.RemediationRecommendation.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Remediation
  ): zio.aws.imagebuilder.model.Remediation.ReadOnly = new Wrapper(impl)
}
