package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.WorkflowStepExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWorkflowStepExecutionRequest(
    stepExecutionId: WorkflowStepExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest = {
    import GetWorkflowStepExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest
      .builder()
      .stepExecutionId(
        WorkflowStepExecutionId.unwrap(stepExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetWorkflowStepExecutionRequest.ReadOnly =
    zio.aws.imagebuilder.model.GetWorkflowStepExecutionRequest
      .wrap(buildAwsValue())
}
object GetWorkflowStepExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetWorkflowStepExecutionRequest =
      zio.aws.imagebuilder.model
        .GetWorkflowStepExecutionRequest(stepExecutionId)
    def stepExecutionId: WorkflowStepExecutionId
    def getStepExecutionId: ZIO[Any, Nothing, WorkflowStepExecutionId] =
      ZIO.succeed(stepExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest
  ) extends zio.aws.imagebuilder.model.GetWorkflowStepExecutionRequest.ReadOnly {
    override val stepExecutionId: WorkflowStepExecutionId =
      zio.aws.imagebuilder.model.primitives
        .WorkflowStepExecutionId(impl.stepExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowStepExecutionRequest
  ): zio.aws.imagebuilder.model.GetWorkflowStepExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
