package zio.aws.imagebuilder.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.imagebuilder.model.primitives.{
  WorkflowStepCount,
  WorkflowExecutionMessage,
  WorkflowExecutionId,
  DateTime,
  ImageBuildVersionArn,
  WorkflowBuildVersionArn,
  NonEmptyString
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetWorkflowExecutionResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      Optional.Absent,
    workflowExecutionId: Optional[WorkflowExecutionId] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent,
    `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] = Optional.Absent,
    status: Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus] =
      Optional.Absent,
    message: Optional[WorkflowExecutionMessage] = Optional.Absent,
    totalStepCount: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsSucceeded: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsFailed: Optional[WorkflowStepCount] = Optional.Absent,
    totalStepsSkipped: Optional[WorkflowStepCount] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse = {
    import GetWorkflowExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        workflowBuildVersionArn.map(value =>
          WorkflowBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.workflowBuildVersionArn)
      .optionallyWith(
        workflowExecutionId.map(value =>
          WorkflowExecutionId.unwrap(value): java.lang.String
        )
      )(_.workflowExecutionId)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value =>
          WorkflowExecutionMessage.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(
        totalStepCount.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepCount)
      .optionallyWith(
        totalStepsSucceeded.map(value =>
          WorkflowStepCount.unwrap(value): Integer
        )
      )(_.totalStepsSucceeded)
      .optionallyWith(
        totalStepsFailed.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepsFailed)
      .optionallyWith(
        totalStepsSkipped.map(value => WorkflowStepCount.unwrap(value): Integer)
      )(_.totalStepsSkipped)
      .optionallyWith(
        startTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DateTime.unwrap(value): java.lang.String)
      )(_.endTime)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetWorkflowExecutionResponse
      .wrap(buildAwsValue())
}
object GetWorkflowExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetWorkflowExecutionResponse =
      zio.aws.imagebuilder.model.GetWorkflowExecutionResponse(
        requestId.map(value => value),
        workflowBuildVersionArn.map(value => value),
        workflowExecutionId.map(value => value),
        imageBuildVersionArn.map(value => value),
        `type`.map(value => value),
        status.map(value => value),
        message.map(value => value),
        totalStepCount.map(value => value),
        totalStepsSucceeded.map(value => value),
        totalStepsFailed.map(value => value),
        totalStepsSkipped.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def workflowBuildVersionArn: Optional[WorkflowBuildVersionArn]
    def workflowExecutionId: Optional[WorkflowExecutionId]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def `type`: Optional[zio.aws.imagebuilder.model.WorkflowType]
    def status: Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus]
    def message: Optional[WorkflowExecutionMessage]
    def totalStepCount: Optional[WorkflowStepCount]
    def totalStepsSucceeded: Optional[WorkflowStepCount]
    def totalStepsFailed: Optional[WorkflowStepCount]
    def totalStepsSkipped: Optional[WorkflowStepCount]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getWorkflowBuildVersionArn
        : ZIO[Any, AwsError, WorkflowBuildVersionArn] = AwsError
      .unwrapOptionField("workflowBuildVersionArn", workflowBuildVersionArn)
    def getWorkflowExecutionId: ZIO[Any, AwsError, WorkflowExecutionId] =
      AwsError.unwrapOptionField("workflowExecutionId", workflowExecutionId)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
    def getType: ZIO[Any, AwsError, zio.aws.imagebuilder.model.WorkflowType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.WorkflowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, WorkflowExecutionMessage] =
      AwsError.unwrapOptionField("message", message)
    def getTotalStepCount: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepCount", totalStepCount)
    def getTotalStepsSucceeded: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsSucceeded", totalStepsSucceeded)
    def getTotalStepsFailed: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsFailed", totalStepsFailed)
    def getTotalStepsSkipped: ZIO[Any, AwsError, WorkflowStepCount] =
      AwsError.unwrapOptionField("totalStepsSkipped", totalStepsSkipped)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse
  ) extends zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val workflowBuildVersionArn: Optional[WorkflowBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowBuildVersionArn(value)
        )
    override val workflowExecutionId: Optional[WorkflowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowExecutionId())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionId(value)
        )
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
    override val `type`: Optional[zio.aws.imagebuilder.model.WorkflowType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.imagebuilder.model.WorkflowType.wrap(value))
    override val status
        : Optional[zio.aws.imagebuilder.model.WorkflowExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.imagebuilder.model.WorkflowExecutionStatus.wrap(value)
        )
    override val message: Optional[WorkflowExecutionMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowExecutionMessage(value)
        )
    override val totalStepCount: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepCount())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsSucceeded: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsSucceeded())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsFailed: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsFailed())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val totalStepsSkipped: Optional[WorkflowStepCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalStepsSkipped())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.WorkflowStepCount(value)
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.imagebuilder.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionResponse
  ): zio.aws.imagebuilder.model.GetWorkflowExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
