package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.WorkflowExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWorkflowExecutionRequest(
    workflowExecutionId: WorkflowExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest = {
    import GetWorkflowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest
      .builder()
      .workflowExecutionId(
        WorkflowExecutionId.unwrap(workflowExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.GetWorkflowExecutionRequest.ReadOnly =
    zio.aws.imagebuilder.model.GetWorkflowExecutionRequest.wrap(buildAwsValue())
}
object GetWorkflowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetWorkflowExecutionRequest =
      zio.aws.imagebuilder.model
        .GetWorkflowExecutionRequest(workflowExecutionId)
    def workflowExecutionId: WorkflowExecutionId
    def getWorkflowExecutionId: ZIO[Any, Nothing, WorkflowExecutionId] =
      ZIO.succeed(workflowExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest
  ) extends zio.aws.imagebuilder.model.GetWorkflowExecutionRequest.ReadOnly {
    override val workflowExecutionId: WorkflowExecutionId =
      zio.aws.imagebuilder.model.primitives
        .WorkflowExecutionId(impl.workflowExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetWorkflowExecutionRequest
  ): zio.aws.imagebuilder.model.GetWorkflowExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
