package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{NonEmptyString, NonNegativeDouble}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CvssScore(
    baseScore: Optional[NonNegativeDouble] = Optional.Absent,
    scoringVector: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    source: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CvssScore = {
    import CvssScore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CvssScore
      .builder()
      .optionallyWith(
        baseScore.map(value =>
          NonNegativeDouble.unwrap(value): java.lang.Double
        )
      )(_.baseScore)
      .optionallyWith(
        scoringVector.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.scoringVector)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.CvssScore.ReadOnly =
    zio.aws.imagebuilder.model.CvssScore.wrap(buildAwsValue())
}
object CvssScore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CvssScore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CvssScore =
      zio.aws.imagebuilder.model.CvssScore(
        baseScore.map(value => value),
        scoringVector.map(value => value),
        version.map(value => value),
        source.map(value => value)
      )
    def baseScore: Optional[NonNegativeDouble]
    def scoringVector: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def source: Optional[NonEmptyString]
    def getBaseScore: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("baseScore", baseScore)
    def getScoringVector: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scoringVector", scoringVector)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScore
  ) extends zio.aws.imagebuilder.model.CvssScore.ReadOnly {
    override val baseScore: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.baseScore())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.NonNegativeDouble(value)
      )
    override val scoringVector: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scoringVector())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val source: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CvssScore
  ): zio.aws.imagebuilder.model.CvssScore.ReadOnly = new Wrapper(impl)
}
