package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ClientToken,
  NonEmptyString,
  DistributionConfigurationArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateDistributionConfigurationRequest(
    distributionConfigurationArn: DistributionConfigurationArn,
    description: Optional[NonEmptyString] = Optional.Absent,
    distributions: Iterable[zio.aws.imagebuilder.model.Distribution],
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest = {
    import UpdateDistributionConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest
      .builder()
      .distributionConfigurationArn(
        DistributionConfigurationArn.unwrap(
          distributionConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .distributions(distributions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest.ReadOnly =
    zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateDistributionConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest =
      zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest(
        distributionConfigurationArn,
        description.map(value => value),
        distributions.map { item =>
          item.asEditable
        },
        clientToken
      )
    def distributionConfigurationArn: DistributionConfigurationArn
    def description: Optional[NonEmptyString]
    def distributions: List[zio.aws.imagebuilder.model.Distribution.ReadOnly]
    def clientToken: ClientToken
    def getDistributionConfigurationArn
        : ZIO[Any, Nothing, DistributionConfigurationArn] =
      ZIO.succeed(distributionConfigurationArn)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDistributions: ZIO[Any, Nothing, List[
      zio.aws.imagebuilder.model.Distribution.ReadOnly
    ]] = ZIO.succeed(distributions)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest
  ) extends zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest.ReadOnly {
    override val distributionConfigurationArn: DistributionConfigurationArn =
      zio.aws.imagebuilder.model.primitives
        .DistributionConfigurationArn(impl.distributionConfigurationArn())
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val distributions
        : List[zio.aws.imagebuilder.model.Distribution.ReadOnly] = impl
      .distributions()
      .asScala
      .map { item =>
        zio.aws.imagebuilder.model.Distribution.wrap(item)
      }
      .toList
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.UpdateDistributionConfigurationRequest
  ): zio.aws.imagebuilder.model.UpdateDistributionConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
