package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Ami(
    region: Optional[NonEmptyString] = Optional.Absent,
    image: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    state: Optional[zio.aws.imagebuilder.model.ImageState] = Optional.Absent,
    accountId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.Ami = {
    import Ami.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.Ami
      .builder()
      .optionallyWith(
        region.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        image.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        accountId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.Ami.ReadOnly =
    zio.aws.imagebuilder.model.Ami.wrap(buildAwsValue())
}
object Ami {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.imagebuilder.model.Ami] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.Ami =
      zio.aws.imagebuilder.model.Ami(
        region.map(value => value),
        image.map(value => value),
        name.map(value => value),
        description.map(value => value),
        state.map(value => value.asEditable),
        accountId.map(value => value)
      )
    def region: Optional[NonEmptyString]
    def image: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def state: Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly]
    def accountId: Optional[NonEmptyString]
    def getRegion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("region", region)
    def getImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("image", image)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getState
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getAccountId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.Ami
  ) extends zio.aws.imagebuilder.model.Ami.ReadOnly {
    override val region: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val image: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val state
        : Optional[zio.aws.imagebuilder.model.ImageState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.imagebuilder.model.ImageState.wrap(value))
    override val accountId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.Ami
  ): zio.aws.imagebuilder.model.Ami.ReadOnly = new Wrapper(impl)
}
