package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContainerRecipesResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    containerRecipeSummaryList: Optional[
      Iterable[zio.aws.imagebuilder.model.ContainerRecipeSummary]
    ] = Optional.Absent,
    nextToken: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse = {
    import ListContainerRecipesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        containerRecipeSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerRecipeSummaryList)
      .optionallyWith(
        nextToken.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly =
    zio.aws.imagebuilder.model.ListContainerRecipesResponse
      .wrap(buildAwsValue())
}
object ListContainerRecipesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ListContainerRecipesResponse =
      zio.aws.imagebuilder.model.ListContainerRecipesResponse(
        requestId.map(value => value),
        containerRecipeSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def containerRecipeSummaryList: Optional[
      List[zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly]
    ]
    def nextToken: Optional[NonEmptyString]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getContainerRecipeSummaryList: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "containerRecipeSummaryList",
      containerRecipeSummaryList
    )
    def getNextToken: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ) extends zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val containerRecipeSummaryList: Optional[
      List[zio.aws.imagebuilder.model.ContainerRecipeSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containerRecipeSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.ContainerRecipeSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ListContainerRecipesResponse
  ): zio.aws.imagebuilder.model.ListContainerRecipesResponse.ReadOnly =
    new Wrapper(impl)
}
