package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  ImageBuildVersionArn,
  ClientToken,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelImageCreationResponse(
    requestId: Optional[NonEmptyString] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    imageBuildVersionArn: Optional[ImageBuildVersionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse = {
    import CancelImageCreationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        imageBuildVersionArn.map(value =>
          ImageBuildVersionArn.unwrap(value): java.lang.String
        )
      )(_.imageBuildVersionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly =
    zio.aws.imagebuilder.model.CancelImageCreationResponse.wrap(buildAwsValue())
}
object CancelImageCreationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CancelImageCreationResponse =
      zio.aws.imagebuilder.model.CancelImageCreationResponse(
        requestId.map(value => value),
        clientToken.map(value => value),
        imageBuildVersionArn.map(value => value)
      )
    def requestId: Optional[NonEmptyString]
    def clientToken: Optional[ClientToken]
    def imageBuildVersionArn: Optional[ImageBuildVersionArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getImageBuildVersionArn: ZIO[Any, AwsError, ImageBuildVersionArn] =
      AwsError.unwrapOptionField("imageBuildVersionArn", imageBuildVersionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ) extends zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly {
    override val requestId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
    override val imageBuildVersionArn: Optional[ImageBuildVersionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imageBuildVersionArn())
        .map(value =>
          zio.aws.imagebuilder.model.primitives.ImageBuildVersionArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationResponse
  ): zio.aws.imagebuilder.model.CancelImageCreationResponse.ReadOnly =
    new Wrapper(impl)
}
