package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ClientToken, ImageBuildVersionArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CancelImageCreationRequest(
    imageBuildVersionArn: ImageBuildVersionArn,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest = {
    import CancelImageCreationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest
      .builder()
      .imageBuildVersionArn(
        ImageBuildVersionArn.unwrap(imageBuildVersionArn): java.lang.String
      )
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CancelImageCreationRequest.ReadOnly =
    zio.aws.imagebuilder.model.CancelImageCreationRequest.wrap(buildAwsValue())
}
object CancelImageCreationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CancelImageCreationRequest =
      zio.aws.imagebuilder.model
        .CancelImageCreationRequest(imageBuildVersionArn, clientToken)
    def imageBuildVersionArn: ImageBuildVersionArn
    def clientToken: ClientToken
    def getImageBuildVersionArn: ZIO[Any, Nothing, ImageBuildVersionArn] =
      ZIO.succeed(imageBuildVersionArn)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest
  ) extends zio.aws.imagebuilder.model.CancelImageCreationRequest.ReadOnly {
    override val imageBuildVersionArn: ImageBuildVersionArn =
      zio.aws.imagebuilder.model.primitives
        .ImageBuildVersionArn(impl.imageBuildVersionArn())
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CancelImageCreationRequest
  ): zio.aws.imagebuilder.model.CancelImageCreationRequest.ReadOnly =
    new Wrapper(impl)
}
