package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait Ownership {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.Ownership
}
object Ownership {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.Ownership
  ): zio.aws.imagebuilder.model.Ownership = value match {
    case software.amazon.awssdk.services.imagebuilder.model.Ownership.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.Ownership.SELF =>
      val r = Self
      r
    case software.amazon.awssdk.services.imagebuilder.model.Ownership.SHARED =>
      val r = Shared
      r
    case software.amazon.awssdk.services.imagebuilder.model.Ownership.AMAZON =>
      val r = Amazon
      r
  }
  case object unknownToSdkVersion extends zio.aws.imagebuilder.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Ownership =
      software.amazon.awssdk.services.imagebuilder.model.Ownership.UNKNOWN_TO_SDK_VERSION
  }
  case object Self extends zio.aws.imagebuilder.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Ownership =
      software.amazon.awssdk.services.imagebuilder.model.Ownership.SELF
  }
  case object Shared extends zio.aws.imagebuilder.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Ownership =
      software.amazon.awssdk.services.imagebuilder.model.Ownership.SHARED
  }
  case object Amazon extends zio.aws.imagebuilder.model.Ownership {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.Ownership =
      software.amazon.awssdk.services.imagebuilder.model.Ownership.AMAZON
  }
}
