package zio.aws.imagebuilder.model
import scala.jdk.CollectionConverters._
sealed trait ImageStatus {
  def unwrap: software.amazon.awssdk.services.imagebuilder.model.ImageStatus
}
object ImageStatus {
  def wrap(
      value: software.amazon.awssdk.services.imagebuilder.model.ImageStatus
  ): zio.aws.imagebuilder.model.ImageStatus = value match {
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.BUILDING =>
      val r = BUILDING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.TESTING =>
      val r = TESTING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DISTRIBUTING =>
      val r = DISTRIBUTING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.INTEGRATING =>
      val r = INTEGRATING
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DEPRECATED =>
      val r = DEPRECATED
      r
    case software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.PENDING
  }
  case object CREATING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.CREATING
  }
  case object BUILDING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.BUILDING
  }
  case object TESTING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.TESTING
  }
  case object DISTRIBUTING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DISTRIBUTING
  }
  case object INTEGRATING extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.INTEGRATING
  }
  case object AVAILABLE extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.AVAILABLE
  }
  case object CANCELLED extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.CANCELLED
  }
  case object FAILED extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.FAILED
  }
  case object DEPRECATED extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DEPRECATED
  }
  case object DELETED extends zio.aws.imagebuilder.model.ImageStatus {
    override def unwrap
        : software.amazon.awssdk.services.imagebuilder.model.ImageStatus =
      software.amazon.awssdk.services.imagebuilder.model.ImageStatus.DELETED
  }
}
