package zio.aws.imagebuilder.model
import java.lang.Integer
import zio.aws.imagebuilder.model.primitives.{
  EbsIopsInteger,
  EbsVolumeSizeInteger,
  NullableBoolean,
  EbsVolumeThroughput,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EbsInstanceBlockDeviceSpecification(
    encrypted: Option[NullableBoolean] = None,
    deleteOnTermination: Option[NullableBoolean] = None,
    iops: Option[EbsIopsInteger] = None,
    kmsKeyId: Option[NonEmptyString] = None,
    snapshotId: Option[NonEmptyString] = None,
    volumeSize: Option[EbsVolumeSizeInteger] = None,
    volumeType: Option[zio.aws.imagebuilder.model.EbsVolumeType] = None,
    throughput: Option[EbsVolumeThroughput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification = {
    import EbsInstanceBlockDeviceSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
      .builder()
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(iops.map(value => EbsIopsInteger.unwrap(value): Integer))(
        _.iops
      )
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        snapshotId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        volumeSize.map(value => EbsVolumeSizeInteger.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        throughput.map(value => EbsVolumeThroughput.unwrap(value): Integer)
      )(_.throughput)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification
      .wrap(buildAwsValue())
}
object EbsInstanceBlockDeviceSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification =
      zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification(
        encrypted.map(value => value),
        deleteOnTermination.map(value => value),
        iops.map(value => value),
        kmsKeyId.map(value => value),
        snapshotId.map(value => value),
        volumeSize.map(value => value),
        volumeType.map(value => value),
        throughput.map(value => value)
      )
    def encrypted: Option[NullableBoolean]
    def deleteOnTermination: Option[NullableBoolean]
    def iops: Option[EbsIopsInteger]
    def kmsKeyId: Option[NonEmptyString]
    def snapshotId: Option[NonEmptyString]
    def volumeSize: Option[EbsVolumeSizeInteger]
    def volumeType: Option[zio.aws.imagebuilder.model.EbsVolumeType]
    def throughput: Option[EbsVolumeThroughput]
    def getEncrypted: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getDeleteOnTermination: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getIops: ZIO[Any, AwsError, EbsIopsInteger] =
      AwsError.unwrapOptionField("iops", iops)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getSnapshotId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getVolumeSize: ZIO[Any, AwsError, EbsVolumeSizeInteger] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getVolumeType
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.EbsVolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getThroughput: ZIO[Any, AwsError, EbsVolumeThroughput] =
      AwsError.unwrapOptionField("throughput", throughput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ) extends zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly {
    override val encrypted: Option[NullableBoolean] =
      scala.Option(impl.encrypted()).map(value => value: NullableBoolean)
    override val deleteOnTermination: Option[NullableBoolean] = scala
      .Option(impl.deleteOnTermination())
      .map(value => value: NullableBoolean)
    override val iops: Option[EbsIopsInteger] = scala
      .Option(impl.iops())
      .map(value => zio.aws.imagebuilder.model.primitives.EbsIopsInteger(value))
    override val kmsKeyId: Option[NonEmptyString] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val snapshotId: Option[NonEmptyString] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val volumeSize: Option[EbsVolumeSizeInteger] = scala
      .Option(impl.volumeSize())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.EbsVolumeSizeInteger(value)
      )
    override val volumeType: Option[zio.aws.imagebuilder.model.EbsVolumeType] =
      scala
        .Option(impl.volumeType())
        .map(value => zio.aws.imagebuilder.model.EbsVolumeType.wrap(value))
    override val throughput: Option[EbsVolumeThroughput] = scala
      .Option(impl.throughput())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.EbsVolumeThroughput(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.EbsInstanceBlockDeviceSpecification
  ): zio.aws.imagebuilder.model.EbsInstanceBlockDeviceSpecification.ReadOnly =
    new Wrapper(impl)
}
