package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{
  DistributionConfigurationArn,
  ImageRecipeArn,
  InfrastructureConfigurationArn,
  TagValue,
  ClientToken,
  ContainerRecipeArn,
  NullableBoolean,
  NonEmptyString,
  ResourceName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateImagePipelineRequest(
    name: ResourceName,
    description: Option[NonEmptyString] = None,
    imageRecipeArn: Option[ImageRecipeArn] = None,
    containerRecipeArn: Option[ContainerRecipeArn] = None,
    infrastructureConfigurationArn: InfrastructureConfigurationArn,
    distributionConfigurationArn: Option[DistributionConfigurationArn] = None,
    imageTestsConfiguration: Option[
      zio.aws.imagebuilder.model.ImageTestsConfiguration
    ] = None,
    enhancedImageMetadataEnabled: Option[NullableBoolean] = None,
    schedule: Option[zio.aws.imagebuilder.model.Schedule] = None,
    status: Option[zio.aws.imagebuilder.model.PipelineStatus] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientToken: ClientToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest = {
    import CreateImagePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        imageRecipeArn.map(value =>
          ImageRecipeArn.unwrap(value): java.lang.String
        )
      )(_.imageRecipeArn)
      .optionallyWith(
        containerRecipeArn.map(value =>
          ContainerRecipeArn.unwrap(value): java.lang.String
        )
      )(_.containerRecipeArn)
      .infrastructureConfigurationArn(
        InfrastructureConfigurationArn.unwrap(
          infrastructureConfigurationArn
        ): java.lang.String
      )
      .optionallyWith(
        distributionConfigurationArn.map(value =>
          DistributionConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.distributionConfigurationArn)
      .optionallyWith(
        imageTestsConfiguration.map(value => value.buildAwsValue())
      )(_.imageTestsConfiguration)
      .optionallyWith(
        enhancedImageMetadataEnabled.map(value => value: java.lang.Boolean)
      )(_.enhancedImageMetadataEnabled)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly =
    zio.aws.imagebuilder.model.CreateImagePipelineRequest.wrap(buildAwsValue())
}
object CreateImagePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.CreateImagePipelineRequest =
      zio.aws.imagebuilder.model.CreateImagePipelineRequest(
        name,
        description.map(value => value),
        imageRecipeArn.map(value => value),
        containerRecipeArn.map(value => value),
        infrastructureConfigurationArn,
        distributionConfigurationArn.map(value => value),
        imageTestsConfiguration.map(value => value.asEditable),
        enhancedImageMetadataEnabled.map(value => value),
        schedule.map(value => value.asEditable),
        status.map(value => value),
        tags.map(value => value),
        clientToken
      )
    def name: ResourceName
    def description: Option[NonEmptyString]
    def imageRecipeArn: Option[ImageRecipeArn]
    def containerRecipeArn: Option[ContainerRecipeArn]
    def infrastructureConfigurationArn: InfrastructureConfigurationArn
    def distributionConfigurationArn: Option[DistributionConfigurationArn]
    def imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly]
    def enhancedImageMetadataEnabled: Option[NullableBoolean]
    def schedule: Option[zio.aws.imagebuilder.model.Schedule.ReadOnly]
    def status: Option[zio.aws.imagebuilder.model.PipelineStatus]
    def tags: Option[Map[TagKey, TagValue]]
    def clientToken: ClientToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getImageRecipeArn: ZIO[Any, AwsError, ImageRecipeArn] =
      AwsError.unwrapOptionField("imageRecipeArn", imageRecipeArn)
    def getContainerRecipeArn: ZIO[Any, AwsError, ContainerRecipeArn] =
      AwsError.unwrapOptionField("containerRecipeArn", containerRecipeArn)
    def getInfrastructureConfigurationArn
        : ZIO[Any, Nothing, InfrastructureConfigurationArn] =
      ZIO.succeed(infrastructureConfigurationArn)
    def getDistributionConfigurationArn
        : ZIO[Any, AwsError, DistributionConfigurationArn] =
      AwsError.unwrapOptionField(
        "distributionConfigurationArn",
        distributionConfigurationArn
      )
    def getImageTestsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "imageTestsConfiguration",
      imageTestsConfiguration
    )
    def getEnhancedImageMetadataEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField(
        "enhancedImageMetadataEnabled",
        enhancedImageMetadataEnabled
      )
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.PipelineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ) extends zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.imagebuilder.model.primitives.ResourceName(impl.name())
    override val description: Option[NonEmptyString] = scala
      .Option(impl.description())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipeArn: Option[ImageRecipeArn] = scala
      .Option(impl.imageRecipeArn())
      .map(value => zio.aws.imagebuilder.model.primitives.ImageRecipeArn(value))
    override val containerRecipeArn: Option[ContainerRecipeArn] = scala
      .Option(impl.containerRecipeArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ContainerRecipeArn(value)
      )
    override val infrastructureConfigurationArn
        : InfrastructureConfigurationArn = zio.aws.imagebuilder.model.primitives
      .InfrastructureConfigurationArn(impl.infrastructureConfigurationArn())
    override val distributionConfigurationArn
        : Option[DistributionConfigurationArn] = scala
      .Option(impl.distributionConfigurationArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives
          .DistributionConfigurationArn(value)
      )
    override val imageTestsConfiguration
        : Option[zio.aws.imagebuilder.model.ImageTestsConfiguration.ReadOnly] =
      scala
        .Option(impl.imageTestsConfiguration())
        .map(value =>
          zio.aws.imagebuilder.model.ImageTestsConfiguration.wrap(value)
        )
    override val enhancedImageMetadataEnabled: Option[NullableBoolean] = scala
      .Option(impl.enhancedImageMetadataEnabled())
      .map(value => value: NullableBoolean)
    override val schedule
        : Option[zio.aws.imagebuilder.model.Schedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.imagebuilder.model.Schedule.wrap(value))
    override val status: Option[zio.aws.imagebuilder.model.PipelineStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.imagebuilder.model.PipelineStatus.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.imagebuilder.model.primitives.TagKey(
              key
            ) -> zio.aws.imagebuilder.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: ClientToken =
      zio.aws.imagebuilder.model.primitives.ClientToken(impl.clientToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.CreateImagePipelineRequest
  ): zio.aws.imagebuilder.model.CreateImagePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
