package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TargetContainerRepository(
    service: zio.aws.imagebuilder.model.ContainerRepositoryService,
    repositoryName: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository = {
    import TargetContainerRepository.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository
      .builder()
      .service(service.unwrap)
      .repositoryName(NonEmptyString.unwrap(repositoryName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly =
    zio.aws.imagebuilder.model.TargetContainerRepository.wrap(buildAwsValue())
}
object TargetContainerRepository {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.TargetContainerRepository =
      zio.aws.imagebuilder.model
        .TargetContainerRepository(service, repositoryName)
    def service: zio.aws.imagebuilder.model.ContainerRepositoryService
    def repositoryName: NonEmptyString
    def getService: ZIO[
      Any,
      Nothing,
      zio.aws.imagebuilder.model.ContainerRepositoryService
    ] = ZIO.succeed(service)
    def getRepositoryName: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(repositoryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository
  ) extends zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly {
    override val service
        : zio.aws.imagebuilder.model.ContainerRepositoryService =
      zio.aws.imagebuilder.model.ContainerRepositoryService.wrap(impl.service())
    override val repositoryName: NonEmptyString =
      zio.aws.imagebuilder.model.primitives
        .NonEmptyString(impl.repositoryName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.TargetContainerRepository
  ): zio.aws.imagebuilder.model.TargetContainerRepository.ReadOnly =
    new Wrapper(impl)
}
