package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceConfiguration(
    image: Option[NonEmptyString] = None,
    blockDeviceMappings: Option[
      Iterable[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration = {
    import InstanceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration
      .builder()
      .optionallyWith(
        image.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly =
    zio.aws.imagebuilder.model.InstanceConfiguration.wrap(buildAwsValue())
}
object InstanceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.InstanceConfiguration =
      zio.aws.imagebuilder.model.InstanceConfiguration(
        image.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def image: Option[NonEmptyString]
    def blockDeviceMappings: Option[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ]
    def getImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("image", image)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration
  ) extends zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly {
    override val image: Option[NonEmptyString] = scala
      .Option(impl.image())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val blockDeviceMappings: Option[
      List[zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.ReadOnly]
    ] = scala
      .Option(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.imagebuilder.model.InstanceBlockDeviceMapping.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.InstanceConfiguration
  ): zio.aws.imagebuilder.model.InstanceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
