package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ClientToken, Arn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ImportVmImageResponse(
    requestId: Option[NonEmptyString] = None,
    imageArn: Option[Arn] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse = {
    import ImportVmImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imageArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.imageArn)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly =
    zio.aws.imagebuilder.model.ImportVmImageResponse.wrap(buildAwsValue())
}
object ImportVmImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.ImportVmImageResponse =
      zio.aws.imagebuilder.model.ImportVmImageResponse(
        requestId.map(value => value),
        imageArn.map(value => value),
        clientToken.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imageArn: Option[Arn]
    def clientToken: Option[ClientToken]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("imageArn", imageArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ) extends zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageArn: Option[Arn] = scala
      .Option(impl.imageArn())
      .map(value => zio.aws.imagebuilder.model.primitives.Arn(value))
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.imagebuilder.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.ImportVmImageResponse
  ): zio.aws.imagebuilder.model.ImportVmImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
