package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetImageRecipeResponse(
    requestId: Option[NonEmptyString] = None,
    imageRecipe: Option[zio.aws.imagebuilder.model.ImageRecipe] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse = {
    import GetImageRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(imageRecipe.map(value => value.buildAwsValue()))(
        _.imageRecipe
      )
      .build()
  }
  def asReadOnly: zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly =
    zio.aws.imagebuilder.model.GetImageRecipeResponse.wrap(buildAwsValue())
}
object GetImageRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.GetImageRecipeResponse =
      zio.aws.imagebuilder.model.GetImageRecipeResponse(
        requestId.map(value => value),
        imageRecipe.map(value => value.asEditable)
      )
    def requestId: Option[NonEmptyString]
    def imageRecipe: Option[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImageRecipe
        : ZIO[Any, AwsError, zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] =
      AwsError.unwrapOptionField("imageRecipe", imageRecipe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse
  ) extends zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imageRecipe
        : Option[zio.aws.imagebuilder.model.ImageRecipe.ReadOnly] = scala
      .Option(impl.imageRecipe())
      .map(value => zio.aws.imagebuilder.model.ImageRecipe.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.GetImageRecipeResponse
  ): zio.aws.imagebuilder.model.GetImageRecipeResponse.ReadOnly = new Wrapper(
    impl
  )
}
