package zio.aws.imagebuilder.model
import zio.aws.imagebuilder.model.primitives.{ImagePipelineArn, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteImagePipelineResponse(
    requestId: Option[NonEmptyString] = None,
    imagePipelineArn: Option[ImagePipelineArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse = {
    import DeleteImagePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
      .builder()
      .optionallyWith(
        requestId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        imagePipelineArn.map(value =>
          ImagePipelineArn.unwrap(value): java.lang.String
        )
      )(_.imagePipelineArn)
      .build()
  }
  def asReadOnly
      : zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly =
    zio.aws.imagebuilder.model.DeleteImagePipelineResponse.wrap(buildAwsValue())
}
object DeleteImagePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.imagebuilder.model.DeleteImagePipelineResponse =
      zio.aws.imagebuilder.model.DeleteImagePipelineResponse(
        requestId.map(value => value),
        imagePipelineArn.map(value => value)
      )
    def requestId: Option[NonEmptyString]
    def imagePipelineArn: Option[ImagePipelineArn]
    def getRequestId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getImagePipelineArn: ZIO[Any, AwsError, ImagePipelineArn] =
      AwsError.unwrapOptionField("imagePipelineArn", imagePipelineArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ) extends zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly {
    override val requestId: Option[NonEmptyString] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.imagebuilder.model.primitives.NonEmptyString(value))
    override val imagePipelineArn: Option[ImagePipelineArn] = scala
      .Option(impl.imagePipelineArn())
      .map(value =>
        zio.aws.imagebuilder.model.primitives.ImagePipelineArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.imagebuilder.model.DeleteImagePipelineResponse
  ): zio.aws.imagebuilder.model.DeleteImagePipelineResponse.ReadOnly =
    new Wrapper(impl)
}
