package zio.aws.identitystore.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.identitystore.model.primitives.AttributePath
import zio.ZIO
import software.amazon.awssdk.core.document.Document
import scala.jdk.CollectionConverters._
final case class AttributeOperation(
    attributePath: AttributePath,
    attributeValue: Optional[zio.aws.identitystore.model.AttributeValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.AttributeOperation = {
    import AttributeOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.AttributeOperation
      .builder()
      .attributePath(AttributePath.unwrap(attributePath): java.lang.String)
      .optionallyWith(attributeValue.map(value => value))(_.attributeValue)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.AttributeOperation.ReadOnly =
    zio.aws.identitystore.model.AttributeOperation.wrap(buildAwsValue())
}
object AttributeOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.AttributeOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.AttributeOperation =
      zio.aws.identitystore.model
        .AttributeOperation(attributePath, attributeValue.map(value => value))
    def attributePath: AttributePath
    def attributeValue: Optional[Document]
    def getAttributePath: ZIO[Any, Nothing, AttributePath] =
      ZIO.succeed(attributePath)
    def getAttributeValue: ZIO[Any, AwsError, Document] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.AttributeOperation
  ) extends zio.aws.identitystore.model.AttributeOperation.ReadOnly {
    override val attributePath: AttributePath =
      zio.aws.identitystore.model.primitives.AttributePath(impl.attributePath())
    override val attributeValue: Optional[Document] =
      zio.aws.core.internal.optionalFromNullable(impl.attributeValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.AttributeOperation
  ): zio.aws.identitystore.model.AttributeOperation.ReadOnly = new Wrapper(impl)
}
