package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateGroupMembershipRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId,
    memberId: zio.aws.identitystore.model.MemberId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest = {
    import CreateGroupMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .memberId(memberId.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.CreateGroupMembershipRequest.ReadOnly =
    zio.aws.identitystore.model.CreateGroupMembershipRequest
      .wrap(buildAwsValue())
}
object CreateGroupMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.CreateGroupMembershipRequest =
      zio.aws.identitystore.model.CreateGroupMembershipRequest(
        identityStoreId,
        groupId,
        memberId.asEditable
      )
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def memberId: zio.aws.identitystore.model.MemberId.ReadOnly
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getMemberId
        : ZIO[Any, Nothing, zio.aws.identitystore.model.MemberId.ReadOnly] =
      ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest
  ) extends zio.aws.identitystore.model.CreateGroupMembershipRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val memberId: zio.aws.identitystore.model.MemberId.ReadOnly =
      zio.aws.identitystore.model.MemberId.wrap(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipRequest
  ): zio.aws.identitystore.model.CreateGroupMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
