package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AlternateIdentifier(
    externalId: Optional[zio.aws.identitystore.model.ExternalId] =
      Optional.Absent,
    uniqueAttribute: Optional[zio.aws.identitystore.model.UniqueAttribute] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.AlternateIdentifier = {
    import AlternateIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.AlternateIdentifier
      .builder()
      .optionallyWith(externalId.map(value => value.buildAwsValue()))(
        _.externalId
      )
      .optionallyWith(uniqueAttribute.map(value => value.buildAwsValue()))(
        _.uniqueAttribute
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.AlternateIdentifier.ReadOnly =
    zio.aws.identitystore.model.AlternateIdentifier.wrap(buildAwsValue())
}
object AlternateIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.AlternateIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.AlternateIdentifier =
      zio.aws.identitystore.model.AlternateIdentifier(
        externalId.map(value => value.asEditable),
        uniqueAttribute.map(value => value.asEditable)
      )
    def externalId: Optional[zio.aws.identitystore.model.ExternalId.ReadOnly]
    def uniqueAttribute
        : Optional[zio.aws.identitystore.model.UniqueAttribute.ReadOnly]
    def getExternalId
        : ZIO[Any, AwsError, zio.aws.identitystore.model.ExternalId.ReadOnly] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getUniqueAttribute: ZIO[
      Any,
      AwsError,
      zio.aws.identitystore.model.UniqueAttribute.ReadOnly
    ] = AwsError.unwrapOptionField("uniqueAttribute", uniqueAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.AlternateIdentifier
  ) extends zio.aws.identitystore.model.AlternateIdentifier.ReadOnly {
    override val externalId
        : Optional[zio.aws.identitystore.model.ExternalId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalId())
        .map(value => zio.aws.identitystore.model.ExternalId.wrap(value))
    override val uniqueAttribute
        : Optional[zio.aws.identitystore.model.UniqueAttribute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueAttribute())
        .map(value => zio.aws.identitystore.model.UniqueAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.AlternateIdentifier
  ): zio.aws.identitystore.model.AlternateIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
