package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{IdentityStoreId, ResourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetUserIdResponse(
    userId: ResourceId,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GetUserIdResponse = {
    import GetUserIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GetUserIdResponse
      .builder()
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.GetUserIdResponse.ReadOnly =
    zio.aws.identitystore.model.GetUserIdResponse.wrap(buildAwsValue())
}
object GetUserIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GetUserIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GetUserIdResponse =
      zio.aws.identitystore.model.GetUserIdResponse(userId, identityStoreId)
    def userId: ResourceId
    def identityStoreId: IdentityStoreId
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GetUserIdResponse
  ) extends zio.aws.identitystore.model.GetUserIdResponse.ReadOnly {
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GetUserIdResponse
  ): zio.aws.identitystore.model.GetUserIdResponse.ReadOnly = new Wrapper(impl)
}
