package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{IdentityStoreId, ResourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGroupMembershipIdResponse(
    membershipId: ResourceId,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse = {
    import GetGroupMembershipIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse
      .builder()
      .membershipId(ResourceId.unwrap(membershipId): java.lang.String)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly =
    zio.aws.identitystore.model.GetGroupMembershipIdResponse
      .wrap(buildAwsValue())
}
object GetGroupMembershipIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GetGroupMembershipIdResponse =
      zio.aws.identitystore.model
        .GetGroupMembershipIdResponse(membershipId, identityStoreId)
    def membershipId: ResourceId
    def identityStoreId: IdentityStoreId
    def getMembershipId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(membershipId)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse
  ) extends zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly {
    override val membershipId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.membershipId())
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdResponse
  ): zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly =
    new Wrapper(impl)
}
