package zio.aws.identitystore
import zio.aws.identitystore.model.ListGroupMembershipsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.identitystore.model.{
  DeleteUserRequest,
  DeleteGroupResponse,
  GroupMembership,
  DeleteGroupMembershipRequest,
  DescribeUserRequest,
  ListGroupMembershipsRequest,
  DescribeGroupMembershipRequest,
  GetUserIdResponse,
  ListUsersRequest,
  ListUsersResponse,
  UpdateGroupRequest,
  DescribeUserResponse,
  User,
  DeleteGroupMembershipResponse,
  CreateGroupMembershipRequest,
  DescribeGroupMembershipResponse,
  DescribeGroupRequest,
  GetGroupMembershipIdResponse,
  DeleteGroupRequest,
  ListGroupMembershipsResponse,
  ListGroupsRequest,
  Group,
  DescribeGroupResponse,
  IsMemberInGroupsRequest,
  CreateGroupMembershipResponse,
  GetGroupIdResponse,
  CreateUserRequest,
  IsMemberInGroupsResponse,
  ListGroupMembershipsForMemberRequest,
  CreateUserResponse,
  GetGroupIdRequest,
  ListGroupsResponse,
  GetGroupMembershipIdRequest,
  CreateGroupResponse,
  DeleteUserResponse,
  ListGroupMembershipsForMemberResponse,
  CreateGroupRequest,
  UpdateUserRequest,
  UpdateUserResponse,
  GetUserIdRequest,
  UpdateGroupResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.identitystore.{
  IdentitystoreAsyncClientBuilder,
  IdentitystoreAsyncClient
}
import scala.jdk.CollectionConverters._
trait Identitystore extends AspectSupport[Identitystore] {
  val api: IdentitystoreAsyncClient
  def listUsers(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.identitystore.model.User.ReadOnly]
  def listUsersPaginated(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): IO[AwsError, zio.aws.identitystore.model.ListUsersResponse.ReadOnly]
  def updateUser(
      request: zio.aws.identitystore.model.UpdateUserRequest
  ): IO[AwsError, zio.aws.identitystore.model.UpdateUserResponse.ReadOnly]
  def createGroupMembership(
      request: zio.aws.identitystore.model.CreateGroupMembershipRequest
  ): IO[
    AwsError,
    zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly
  ]
  def getGroupId(
      request: zio.aws.identitystore.model.GetGroupIdRequest
  ): IO[AwsError, zio.aws.identitystore.model.GetGroupIdResponse.ReadOnly]
  def deleteGroup(
      request: zio.aws.identitystore.model.DeleteGroupRequest
  ): IO[AwsError, zio.aws.identitystore.model.DeleteGroupResponse.ReadOnly]
  def isMemberInGroups(
      request: zio.aws.identitystore.model.IsMemberInGroupsRequest
  ): IO[AwsError, zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly]
  def getUserId(
      request: zio.aws.identitystore.model.GetUserIdRequest
  ): IO[AwsError, zio.aws.identitystore.model.GetUserIdResponse.ReadOnly]
  def listGroups(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.identitystore.model.Group.ReadOnly]
  def listGroupsPaginated(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): IO[AwsError, zio.aws.identitystore.model.ListGroupsResponse.ReadOnly]
  def deleteGroupMembership(
      request: zio.aws.identitystore.model.DeleteGroupMembershipRequest
  ): IO[
    AwsError,
    zio.aws.identitystore.model.DeleteGroupMembershipResponse.ReadOnly
  ]
  def createUser(
      request: zio.aws.identitystore.model.CreateUserRequest
  ): IO[AwsError, zio.aws.identitystore.model.CreateUserResponse.ReadOnly]
  def describeGroup(
      request: zio.aws.identitystore.model.DescribeGroupRequest
  ): IO[AwsError, zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly]
  def createGroup(
      request: zio.aws.identitystore.model.CreateGroupRequest
  ): IO[AwsError, zio.aws.identitystore.model.CreateGroupResponse.ReadOnly]
  def listGroupMemberships(
      request: zio.aws.identitystore.model.ListGroupMembershipsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.identitystore.model.GroupMembership.ReadOnly
  ]
  def listGroupMembershipsPaginated(
      request: zio.aws.identitystore.model.ListGroupMembershipsRequest
  ): IO[AwsError, ReadOnly]
  def describeGroupMembership(
      request: zio.aws.identitystore.model.DescribeGroupMembershipRequest
  ): IO[
    AwsError,
    zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly
  ]
  def describeUser(
      request: zio.aws.identitystore.model.DescribeUserRequest
  ): IO[AwsError, zio.aws.identitystore.model.DescribeUserResponse.ReadOnly]
  def updateGroup(
      request: zio.aws.identitystore.model.UpdateGroupRequest
  ): IO[AwsError, zio.aws.identitystore.model.UpdateGroupResponse.ReadOnly]
  def deleteUser(
      request: zio.aws.identitystore.model.DeleteUserRequest
  ): IO[AwsError, zio.aws.identitystore.model.DeleteUserResponse.ReadOnly]
  def listGroupMembershipsForMember(
      request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.identitystore.model.GroupMembership.ReadOnly
  ]
  def listGroupMembershipsForMemberPaginated(
      request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
  ): IO[
    AwsError,
    zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly
  ]
  def getGroupMembershipId(
      request: zio.aws.identitystore.model.GetGroupMembershipIdRequest
  ): IO[
    AwsError,
    zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly
  ]
}
object Identitystore {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Identitystore] = customized(
    identity
  )
  def customized(
      customization: IdentitystoreAsyncClientBuilder => IdentitystoreAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Identitystore] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IdentitystoreAsyncClientBuilder => IdentitystoreAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Identitystore] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IdentitystoreAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IdentitystoreAsyncClient, IdentitystoreAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IdentitystoreAsyncClient,
      IdentitystoreAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IdentitystoreImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IdentitystoreImpl[R](
      override val api: IdentitystoreAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Identitystore
      with AwsServiceBase[R] {
    override val serviceName: String = "Identitystore"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IdentitystoreImpl[R1] = new IdentitystoreImpl(api, newAspect, r)
    def listUsers(
        request: zio.aws.identitystore.model.ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.identitystore.model.User.ReadOnly] =
      asyncSimplePaginatedRequest[ListUsersRequest, ListUsersResponse, User](
        "listUsers",
        api.listUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.users().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.identitystore.model.User.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: zio.aws.identitystore.model.ListUsersRequest
    ): IO[AwsError, zio.aws.identitystore.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[ListUsersRequest, ListUsersResponse](
        "listUsers",
        api.listUsers
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
    def updateUser(
        request: zio.aws.identitystore.model.UpdateUserRequest
    ): IO[AwsError, zio.aws.identitystore.model.UpdateUserResponse.ReadOnly] =
      asyncRequestResponse[UpdateUserRequest, UpdateUserResponse](
        "updateUser",
        api.updateUser
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.UpdateUserResponse.wrap)
        .provideEnvironment(r)
    def createGroupMembership(
        request: zio.aws.identitystore.model.CreateGroupMembershipRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateGroupMembershipRequest,
      CreateGroupMembershipResponse
    ]("createGroupMembership", api.createGroupMembership)(
      request.buildAwsValue()
    ).map(zio.aws.identitystore.model.CreateGroupMembershipResponse.wrap)
      .provideEnvironment(r)
    def getGroupId(
        request: zio.aws.identitystore.model.GetGroupIdRequest
    ): IO[AwsError, zio.aws.identitystore.model.GetGroupIdResponse.ReadOnly] =
      asyncRequestResponse[GetGroupIdRequest, GetGroupIdResponse](
        "getGroupId",
        api.getGroupId
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.GetGroupIdResponse.wrap)
        .provideEnvironment(r)
    def deleteGroup(
        request: zio.aws.identitystore.model.DeleteGroupRequest
    ): IO[AwsError, zio.aws.identitystore.model.DeleteGroupResponse.ReadOnly] =
      asyncRequestResponse[DeleteGroupRequest, DeleteGroupResponse](
        "deleteGroup",
        api.deleteGroup
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.DeleteGroupResponse.wrap)
        .provideEnvironment(r)
    def isMemberInGroups(
        request: zio.aws.identitystore.model.IsMemberInGroupsRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly
    ] = asyncRequestResponse[IsMemberInGroupsRequest, IsMemberInGroupsResponse](
      "isMemberInGroups",
      api.isMemberInGroups
    )(request.buildAwsValue())
      .map(zio.aws.identitystore.model.IsMemberInGroupsResponse.wrap)
      .provideEnvironment(r)
    def getUserId(
        request: zio.aws.identitystore.model.GetUserIdRequest
    ): IO[AwsError, zio.aws.identitystore.model.GetUserIdResponse.ReadOnly] =
      asyncRequestResponse[GetUserIdRequest, GetUserIdResponse](
        "getUserId",
        api.getUserId
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.GetUserIdResponse.wrap)
        .provideEnvironment(r)
    def listGroups(
        request: zio.aws.identitystore.model.ListGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.identitystore.model.Group.ReadOnly] =
      asyncSimplePaginatedRequest[ListGroupsRequest, ListGroupsResponse, Group](
        "listGroups",
        api.listGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.groups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.identitystore.model.Group.wrap(item))
        .provideEnvironment(r)
    def listGroupsPaginated(
        request: zio.aws.identitystore.model.ListGroupsRequest
    ): IO[AwsError, zio.aws.identitystore.model.ListGroupsResponse.ReadOnly] =
      asyncRequestResponse[ListGroupsRequest, ListGroupsResponse](
        "listGroups",
        api.listGroups
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.ListGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteGroupMembership(
        request: zio.aws.identitystore.model.DeleteGroupMembershipRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.DeleteGroupMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteGroupMembershipRequest,
      DeleteGroupMembershipResponse
    ]("deleteGroupMembership", api.deleteGroupMembership)(
      request.buildAwsValue()
    ).map(zio.aws.identitystore.model.DeleteGroupMembershipResponse.wrap)
      .provideEnvironment(r)
    def createUser(
        request: zio.aws.identitystore.model.CreateUserRequest
    ): IO[AwsError, zio.aws.identitystore.model.CreateUserResponse.ReadOnly] =
      asyncRequestResponse[CreateUserRequest, CreateUserResponse](
        "createUser",
        api.createUser
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.CreateUserResponse.wrap)
        .provideEnvironment(r)
    def describeGroup(
        request: zio.aws.identitystore.model.DescribeGroupRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
    ] = asyncRequestResponse[DescribeGroupRequest, DescribeGroupResponse](
      "describeGroup",
      api.describeGroup
    )(request.buildAwsValue())
      .map(zio.aws.identitystore.model.DescribeGroupResponse.wrap)
      .provideEnvironment(r)
    def createGroup(
        request: zio.aws.identitystore.model.CreateGroupRequest
    ): IO[AwsError, zio.aws.identitystore.model.CreateGroupResponse.ReadOnly] =
      asyncRequestResponse[CreateGroupRequest, CreateGroupResponse](
        "createGroup",
        api.createGroup
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.CreateGroupResponse.wrap)
        .provideEnvironment(r)
    def listGroupMemberships(
        request: zio.aws.identitystore.model.ListGroupMembershipsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.identitystore.model.GroupMembership.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListGroupMembershipsRequest,
      ListGroupMembershipsResponse,
      GroupMembership
    ](
      "listGroupMemberships",
      api.listGroupMemberships,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groupMemberships().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.identitystore.model.GroupMembership.wrap(item))
      .provideEnvironment(r)
    def listGroupMembershipsPaginated(
        request: zio.aws.identitystore.model.ListGroupMembershipsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListGroupMembershipsRequest,
      ListGroupMembershipsResponse
    ]("listGroupMemberships", api.listGroupMemberships)(request.buildAwsValue())
      .map(zio.aws.identitystore.model.ListGroupMembershipsResponse.wrap)
      .provideEnvironment(r)
    def describeGroupMembership(
        request: zio.aws.identitystore.model.DescribeGroupMembershipRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGroupMembershipRequest,
      DescribeGroupMembershipResponse
    ]("describeGroupMembership", api.describeGroupMembership)(
      request.buildAwsValue()
    ).map(zio.aws.identitystore.model.DescribeGroupMembershipResponse.wrap)
      .provideEnvironment(r)
    def describeUser(
        request: zio.aws.identitystore.model.DescribeUserRequest
    ): IO[AwsError, zio.aws.identitystore.model.DescribeUserResponse.ReadOnly] =
      asyncRequestResponse[DescribeUserRequest, DescribeUserResponse](
        "describeUser",
        api.describeUser
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.DescribeUserResponse.wrap)
        .provideEnvironment(r)
    def updateGroup(
        request: zio.aws.identitystore.model.UpdateGroupRequest
    ): IO[AwsError, zio.aws.identitystore.model.UpdateGroupResponse.ReadOnly] =
      asyncRequestResponse[UpdateGroupRequest, UpdateGroupResponse](
        "updateGroup",
        api.updateGroup
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.UpdateGroupResponse.wrap)
        .provideEnvironment(r)
    def deleteUser(
        request: zio.aws.identitystore.model.DeleteUserRequest
    ): IO[AwsError, zio.aws.identitystore.model.DeleteUserResponse.ReadOnly] =
      asyncRequestResponse[DeleteUserRequest, DeleteUserResponse](
        "deleteUser",
        api.deleteUser
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.DeleteUserResponse.wrap)
        .provideEnvironment(r)
    def listGroupMembershipsForMember(
        request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.identitystore.model.GroupMembership.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListGroupMembershipsForMemberRequest,
      ListGroupMembershipsForMemberResponse,
      GroupMembership
    ](
      "listGroupMembershipsForMember",
      api.listGroupMembershipsForMember,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groupMemberships().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.identitystore.model.GroupMembership.wrap(item))
      .provideEnvironment(r)
    def listGroupMembershipsForMemberPaginated(
        request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      ListGroupMembershipsForMemberRequest,
      ListGroupMembershipsForMemberResponse
    ]("listGroupMembershipsForMember", api.listGroupMembershipsForMember)(
      request.buildAwsValue()
    ).map(
      zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.wrap
    ).provideEnvironment(r)
    def getGroupMembershipId(
        request: zio.aws.identitystore.model.GetGroupMembershipIdRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly
    ] = asyncRequestResponse[
      GetGroupMembershipIdRequest,
      GetGroupMembershipIdResponse
    ]("getGroupMembershipId", api.getGroupMembershipId)(request.buildAwsValue())
      .map(zio.aws.identitystore.model.GetGroupMembershipIdResponse.wrap)
      .provideEnvironment(r)
  }
  def listUsers(request: zio.aws.identitystore.model.ListUsersRequest): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
  def updateUser(request: zio.aws.identitystore.model.UpdateUserRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.UpdateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUser(request))
  def createGroupMembership(
      request: zio.aws.identitystore.model.CreateGroupMembershipRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroupMembership(request))
  def getGroupId(request: zio.aws.identitystore.model.GetGroupIdRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.GetGroupIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupId(request))
  def deleteGroup(request: zio.aws.identitystore.model.DeleteGroupRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DeleteGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGroup(request))
  def isMemberInGroups(
      request: zio.aws.identitystore.model.IsMemberInGroupsRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.isMemberInGroups(request))
  def getUserId(request: zio.aws.identitystore.model.GetUserIdRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.GetUserIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUserId(request))
  def listGroups(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.Group.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroups(request))
  def listGroupsPaginated(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.ListGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsPaginated(request))
  def deleteGroupMembership(
      request: zio.aws.identitystore.model.DeleteGroupMembershipRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DeleteGroupMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGroupMembership(request))
  def createUser(request: zio.aws.identitystore.model.CreateUserRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.CreateUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUser(request))
  def describeGroup(
      request: zio.aws.identitystore.model.DescribeGroupRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGroup(request))
  def createGroup(request: zio.aws.identitystore.model.CreateGroupRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.CreateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroup(request))
  def listGroupMemberships(
      request: zio.aws.identitystore.model.ListGroupMembershipsRequest
  ): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.GroupMembership.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroupMemberships(request))
  def listGroupMembershipsPaginated(
      request: zio.aws.identitystore.model.ListGroupMembershipsRequest
  ): ZIO[zio.aws.identitystore.Identitystore, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listGroupMembershipsPaginated(request))
  def describeGroupMembership(
      request: zio.aws.identitystore.model.DescribeGroupMembershipRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGroupMembership(request))
  def describeUser(
      request: zio.aws.identitystore.model.DescribeUserRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUser(request))
  def updateGroup(request: zio.aws.identitystore.model.UpdateGroupRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.UpdateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroup(request))
  def deleteUser(request: zio.aws.identitystore.model.DeleteUserRequest): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DeleteUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUser(request))
  def listGroupMembershipsForMember(
      request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
  ): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.GroupMembership.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroupMembershipsForMember(request))
  def listGroupMembershipsForMemberPaginated(
      request: zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupMembershipsForMemberPaginated(request))
  def getGroupMembershipId(
      request: zio.aws.identitystore.model.GetGroupMembershipIdRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupMembershipId(request))
}
