package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  SensitiveBooleanType,
  SensitiveStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PhoneNumber(
    value: Optional[SensitiveStringType] = Optional.Absent,
    `type`: Optional[SensitiveStringType] = Optional.Absent,
    primary: Optional[SensitiveBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.PhoneNumber = {
    import PhoneNumber.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.PhoneNumber
      .builder()
      .optionallyWith(
        value.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        `type`.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        primary.map(value =>
          SensitiveBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.primary)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.PhoneNumber.ReadOnly =
    zio.aws.identitystore.model.PhoneNumber.wrap(buildAwsValue())
}
object PhoneNumber {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.PhoneNumber
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.PhoneNumber =
      zio.aws.identitystore.model.PhoneNumber(
        value.map(value => value),
        `type`.map(value => value),
        primary.map(value => value)
      )
    def value: Optional[SensitiveStringType]
    def `type`: Optional[SensitiveStringType]
    def primary: Optional[SensitiveBooleanType]
    def getValue: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("value", value)
    def getType: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPrimary: ZIO[Any, AwsError, SensitiveBooleanType] =
      AwsError.unwrapOptionField("primary", primary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.PhoneNumber
  ) extends zio.aws.identitystore.model.PhoneNumber.ReadOnly {
    override val value: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val `type`: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val primary: Optional[SensitiveBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveBooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.PhoneNumber
  ): zio.aws.identitystore.model.PhoneNumber.ReadOnly = new Wrapper(impl)
}
