package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IsMemberInGroupsResponse(
    results: Iterable[
      zio.aws.identitystore.model.GroupMembershipExistenceResult
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse = {
    import IsMemberInGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse
      .builder()
      .results(results.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly =
    zio.aws.identitystore.model.IsMemberInGroupsResponse.wrap(buildAwsValue())
}
object IsMemberInGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.IsMemberInGroupsResponse =
      zio.aws.identitystore.model.IsMemberInGroupsResponse(results.map { item =>
        item.asEditable
      })
    def results: List[
      zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly
    ]
    def getResults: ZIO[Any, Nothing, List[
      zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly
    ]] = ZIO.succeed(results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse
  ) extends zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly {
    override val results: List[
      zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly
    ] = impl
      .results()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.GroupMembershipExistenceResult.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsResponse
  ): zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
