package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  IdentityStoreId,
  SensitiveStringType,
  ResourceId,
  UserName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class User(
    userName: Optional[UserName] = Optional.Absent,
    userId: ResourceId,
    externalIds: Optional[Iterable[zio.aws.identitystore.model.ExternalId]] =
      Optional.Absent,
    name: Optional[zio.aws.identitystore.model.Name] = Optional.Absent,
    displayName: Optional[SensitiveStringType] = Optional.Absent,
    nickName: Optional[SensitiveStringType] = Optional.Absent,
    profileUrl: Optional[SensitiveStringType] = Optional.Absent,
    emails: Optional[Iterable[zio.aws.identitystore.model.Email]] =
      Optional.Absent,
    addresses: Optional[Iterable[zio.aws.identitystore.model.Address]] =
      Optional.Absent,
    phoneNumbers: Optional[Iterable[zio.aws.identitystore.model.PhoneNumber]] =
      Optional.Absent,
    userType: Optional[SensitiveStringType] = Optional.Absent,
    title: Optional[SensitiveStringType] = Optional.Absent,
    preferredLanguage: Optional[SensitiveStringType] = Optional.Absent,
    locale: Optional[SensitiveStringType] = Optional.Absent,
    timezone: Optional[SensitiveStringType] = Optional.Absent,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.User
      .builder()
      .optionallyWith(
        userName.map(value => UserName.unwrap(value): java.lang.String)
      )(_.userName)
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .optionallyWith(
        externalIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.externalIds)
      .optionallyWith(name.map(value => value.buildAwsValue()))(_.name)
      .optionallyWith(
        displayName.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        nickName.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.nickName)
      .optionallyWith(
        profileUrl.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.profileUrl)
      .optionallyWith(
        emails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emails)
      .optionallyWith(
        addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addresses)
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        userType.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.userType)
      .optionallyWith(
        title.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        preferredLanguage.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.preferredLanguage)
      .optionallyWith(
        locale.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        timezone.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.timezone)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.User.ReadOnly =
    zio.aws.identitystore.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.User
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.User =
      zio.aws.identitystore.model.User(
        userName.map(value => value),
        userId,
        externalIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value.asEditable),
        displayName.map(value => value),
        nickName.map(value => value),
        profileUrl.map(value => value),
        emails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        addresses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userType.map(value => value),
        title.map(value => value),
        preferredLanguage.map(value => value),
        locale.map(value => value),
        timezone.map(value => value),
        identityStoreId
      )
    def userName: Optional[UserName]
    def userId: ResourceId
    def externalIds
        : Optional[List[zio.aws.identitystore.model.ExternalId.ReadOnly]]
    def name: Optional[zio.aws.identitystore.model.Name.ReadOnly]
    def displayName: Optional[SensitiveStringType]
    def nickName: Optional[SensitiveStringType]
    def profileUrl: Optional[SensitiveStringType]
    def emails: Optional[List[zio.aws.identitystore.model.Email.ReadOnly]]
    def addresses: Optional[List[zio.aws.identitystore.model.Address.ReadOnly]]
    def phoneNumbers
        : Optional[List[zio.aws.identitystore.model.PhoneNumber.ReadOnly]]
    def userType: Optional[SensitiveStringType]
    def title: Optional[SensitiveStringType]
    def preferredLanguage: Optional[SensitiveStringType]
    def locale: Optional[SensitiveStringType]
    def timezone: Optional[SensitiveStringType]
    def identityStoreId: IdentityStoreId
    def getUserName: ZIO[Any, AwsError, UserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
    def getExternalIds: ZIO[Any, AwsError, List[
      zio.aws.identitystore.model.ExternalId.ReadOnly
    ]] = AwsError.unwrapOptionField("externalIds", externalIds)
    def getName: ZIO[Any, AwsError, zio.aws.identitystore.model.Name.ReadOnly] =
      AwsError.unwrapOptionField("name", name)
    def getDisplayName: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getNickName: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("nickName", nickName)
    def getProfileUrl: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("profileUrl", profileUrl)
    def getEmails
        : ZIO[Any, AwsError, List[zio.aws.identitystore.model.Email.ReadOnly]] =
      AwsError.unwrapOptionField("emails", emails)
    def getAddresses: ZIO[Any, AwsError, List[
      zio.aws.identitystore.model.Address.ReadOnly
    ]] = AwsError.unwrapOptionField("addresses", addresses)
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.identitystore.model.PhoneNumber.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getUserType: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("userType", userType)
    def getTitle: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("title", title)
    def getPreferredLanguage: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("preferredLanguage", preferredLanguage)
    def getLocale: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("locale", locale)
    def getTimezone: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.User
  ) extends zio.aws.identitystore.model.User.ReadOnly {
    override val userName: Optional[UserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.identitystore.model.primitives.UserName(value))
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
    override val externalIds
        : Optional[List[zio.aws.identitystore.model.ExternalId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.ExternalId.wrap(item)
          }.toList
        )
    override val name: Optional[zio.aws.identitystore.model.Name.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.identitystore.model.Name.wrap(value))
    override val displayName: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val nickName: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.nickName())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val profileUrl: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profileUrl())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val emails
        : Optional[List[zio.aws.identitystore.model.Email.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.Email.wrap(item)
          }.toList
        )
    override val addresses
        : Optional[List[zio.aws.identitystore.model.Address.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.Address.wrap(item)
          }.toList
        )
    override val phoneNumbers
        : Optional[List[zio.aws.identitystore.model.PhoneNumber.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.PhoneNumber.wrap(item)
          }.toList
        )
    override val userType: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.userType())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val title: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val preferredLanguage: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredLanguage())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val locale: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val timezone: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.User
  ): zio.aws.identitystore.model.User.ReadOnly = new Wrapper(impl)
}
