package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GroupMembership(
    identityStoreId: IdentityStoreId,
    membershipId: Optional[ResourceId] = Optional.Absent,
    groupId: Optional[ResourceId] = Optional.Absent,
    memberId: Optional[zio.aws.identitystore.model.MemberId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GroupMembership = {
    import GroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GroupMembership
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .optionallyWith(
        membershipId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.membershipId)
      .optionallyWith(
        groupId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(memberId.map(value => value.buildAwsValue()))(_.memberId)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.GroupMembership.ReadOnly =
    zio.aws.identitystore.model.GroupMembership.wrap(buildAwsValue())
}
object GroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GroupMembership =
      zio.aws.identitystore.model.GroupMembership(
        identityStoreId,
        membershipId.map(value => value),
        groupId.map(value => value),
        memberId.map(value => value.asEditable)
      )
    def identityStoreId: IdentityStoreId
    def membershipId: Optional[ResourceId]
    def groupId: Optional[ResourceId]
    def memberId: Optional[zio.aws.identitystore.model.MemberId.ReadOnly]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMembershipId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("membershipId", membershipId)
    def getGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getMemberId
        : ZIO[Any, AwsError, zio.aws.identitystore.model.MemberId.ReadOnly] =
      AwsError.unwrapOptionField("memberId", memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GroupMembership
  ) extends zio.aws.identitystore.model.GroupMembership.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val membershipId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.membershipId())
      .map(value => zio.aws.identitystore.model.primitives.ResourceId(value))
    override val groupId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.identitystore.model.primitives.ResourceId(value))
    override val memberId
        : Optional[zio.aws.identitystore.model.MemberId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberId())
        .map(value => zio.aws.identitystore.model.MemberId.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GroupMembership
  ): zio.aws.identitystore.model.GroupMembership.ReadOnly = new Wrapper(impl)
}
