package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGroupMembershipIdRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId,
    memberId: zio.aws.identitystore.model.MemberId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest = {
    import GetGroupMembershipIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .memberId(memberId.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.GetGroupMembershipIdRequest.ReadOnly =
    zio.aws.identitystore.model.GetGroupMembershipIdRequest
      .wrap(buildAwsValue())
}
object GetGroupMembershipIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GetGroupMembershipIdRequest =
      zio.aws.identitystore.model.GetGroupMembershipIdRequest(
        identityStoreId,
        groupId,
        memberId.asEditable
      )
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def memberId: zio.aws.identitystore.model.MemberId.ReadOnly
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getMemberId
        : ZIO[Any, Nothing, zio.aws.identitystore.model.MemberId.ReadOnly] =
      ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest
  ) extends zio.aws.identitystore.model.GetGroupMembershipIdRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val memberId: zio.aws.identitystore.model.MemberId.ReadOnly =
      zio.aws.identitystore.model.MemberId.wrap(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupMembershipIdRequest
  ): zio.aws.identitystore.model.GetGroupMembershipIdRequest.ReadOnly =
    new Wrapper(impl)
}
