package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateGroupRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId,
    operations: Iterable[zio.aws.identitystore.model.AttributeOperation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest = {
    import UpdateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .operations(operations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.UpdateGroupRequest.ReadOnly =
    zio.aws.identitystore.model.UpdateGroupRequest.wrap(buildAwsValue())
}
object UpdateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.UpdateGroupRequest =
      zio.aws.identitystore.model.UpdateGroupRequest(
        identityStoreId,
        groupId,
        operations.map { item =>
          item.asEditable
        }
      )
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def operations
        : List[zio.aws.identitystore.model.AttributeOperation.ReadOnly]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.identitystore.model.AttributeOperation.ReadOnly
    ]] = ZIO.succeed(operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest
  ) extends zio.aws.identitystore.model.UpdateGroupRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val operations
        : List[zio.aws.identitystore.model.AttributeOperation.ReadOnly] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.AttributeOperation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.UpdateGroupRequest
  ): zio.aws.identitystore.model.UpdateGroupRequest.ReadOnly = new Wrapper(impl)
}
