package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{SensitiveBooleanType, ResourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GroupMembershipExistenceResult(
    groupId: Optional[ResourceId] = Optional.Absent,
    memberId: Optional[zio.aws.identitystore.model.MemberId] = Optional.Absent,
    membershipExists: Optional[SensitiveBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GroupMembershipExistenceResult = {
    import GroupMembershipExistenceResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GroupMembershipExistenceResult
      .builder()
      .optionallyWith(
        groupId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(memberId.map(value => value.buildAwsValue()))(_.memberId)
      .optionallyWith(
        membershipExists.map(value =>
          SensitiveBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.membershipExists)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly =
    zio.aws.identitystore.model.GroupMembershipExistenceResult
      .wrap(buildAwsValue())
}
object GroupMembershipExistenceResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GroupMembershipExistenceResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GroupMembershipExistenceResult =
      zio.aws.identitystore.model.GroupMembershipExistenceResult(
        groupId.map(value => value),
        memberId.map(value => value.asEditable),
        membershipExists.map(value => value)
      )
    def groupId: Optional[ResourceId]
    def memberId: Optional[zio.aws.identitystore.model.MemberId.ReadOnly]
    def membershipExists: Optional[SensitiveBooleanType]
    def getGroupId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getMemberId
        : ZIO[Any, AwsError, zio.aws.identitystore.model.MemberId.ReadOnly] =
      AwsError.unwrapOptionField("memberId", memberId)
    def getMembershipExists: ZIO[Any, AwsError, SensitiveBooleanType] =
      AwsError.unwrapOptionField("membershipExists", membershipExists)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GroupMembershipExistenceResult
  ) extends zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly {
    override val groupId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => zio.aws.identitystore.model.primitives.ResourceId(value))
    override val memberId
        : Optional[zio.aws.identitystore.model.MemberId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memberId())
        .map(value => zio.aws.identitystore.model.MemberId.wrap(value))
    override val membershipExists: Optional[SensitiveBooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.membershipExists())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveBooleanType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GroupMembershipExistenceResult
  ): zio.aws.identitystore.model.GroupMembershipExistenceResult.ReadOnly =
    new Wrapper(impl)
}
